from setuptools import find_packages
from setuptools import setup


def get_version(name):
    """Reads the version number from the version.py file."""
    import os
    globals = {}
    exec(open(os.path.join(os.path.dirname(__file__), 'network_dev_config', 'version.py')).read(), globals)
    return globals['__version__']


title = "network_dev_config"


setup(
    name=title,
    version=get_version(title),
    python_requires='>=3.2',
    install_requires=[
        'ncclient',
        'tabulate',
        'zeroconf',
    ],
    description="NI Expansion I/O RSTP Reconfigurator",
    author="National Instruments",
    author_email="no-reply@ni.com",
    url="http://dashboard/ni-pypi-docs/network_dev_config-0.1.0d0",
    long_description=open('README.txt').read(),
    include_package_data=True,
    packages=find_packages(),
    entry_points={
        'console_scripts': [
            'network_dev_config=network_dev_config.network_dev_config:main'
        ]
    },
    classifiers=[
        "Topic :: Utilities",
    ],
)
