from time import sleep
from zeroconf import ServiceBrowser
from zeroconf import Zeroconf


class Listener(object):
    def __init__(self):
        self.infos = {}

    def remove_service(self, zeroconf, stype, name):
        if name in self.infos:
            del self.infos[name]

    def add_service(self, zeroconf, stype, name):
        self.infos[name] = zeroconf.get_service_info(stype, name)


def discover_switch_devices(timeout):
    zc = Zeroconf()
    listener = Listener()
    try:
        _ = ServiceBrowser(zc, '_netconf-ssh._tcp.local.', listener)  # noqa F841
        sleep(timeout)
    finally:
        zc.close()

    return sorted(list(listener.infos.values()), key=lambda k: k.server)
