#!/bin/bash

	case "$1" in
		-h|--help)
			echo ""
			echo "This script enables, disables, and prints the current state of the Meltdown/Spectre Security Mitigations."
			echo ""
			echo "options:"
			echo "-h, --help		show brief help"
			echo "-p, --print 		print the current state of the mitigations"
			echo "-e, --enable		enable all configurable mitigations; reboot target"
			echo "-d, --disabled		disable all configurable mitigations; reboot target" 
			exit 0;
			;;
			
		-p|--print)
			# Print current state of vulnerabilities
			echo ""
			echo "Current state of mitigations:"
			grep . /sys/devices/system/cpu/vulnerabilities/*
			echo ""
			exit 0
			;;
		
		-e|--enable)
			# Enable mitigations in INI file 			
			nirtcfg --set section=SYSTEMSETTINGS,token=l1tf.mitigations.disabled,value="False"
			nirtcfg --set section=SYSTEMSETTINGS,token=spectre_v2.mitigations.disabled,value="False"
			nirtcfg --set section=SYSTEMSETTINGS,token=spectre_v4.mitigations.disabled,value="False"
			nirtcfg --set section=SYSTEMSETTINGS,token=meltdown.mitigations.disabled,value="False"			
			
			# Reboot controller to enable mitigations
			echo "Mitigations enabled." 
			read -p "Rebooting the controller..." -t 5
			reboot
			;;

		-d|--disable)
			# Disable mitigations in INI file 			
			nirtcfg --set section=SYSTEMSETTINGS,token=l1tf.mitigations.disabled,value="True"
			nirtcfg --set section=SYSTEMSETTINGS,token=spectre_v2.mitigations.disabled,value="True"
			nirtcfg --set section=SYSTEMSETTINGS,token=spectre_v4.mitigations.disabled,value="True"
			nirtcfg --set section=SYSTEMSETTINGS,token=meltdown.mitigations.disabled,value="True"			
			
			# Reboot controller to disable mitigations
			echo "Mitigations disabled."
			read -p "Rebooting the controller..." -t 5
			reboot
			;;
		*)
			# Invalid flag specified
			echo "Invalid flag. Use --help for help information"
			exit 1
			;;
		esac


