#include <stdio.h>
#include <unistd.h>
#include <inttypes.h>

#include "capi/NiFpga.h"
#include "capi/NiFpga_HMB.h"
#include "capi/NiFpga_HMBFPGA.h"

const char* bitfilePath =
"/home/admin/hmbcapi/capi/NiFpga_HMBFPGA.lvbitx";
const char* hostMemoryBufferName = "HMB1";

int main()
{
	NiFpga_Status status = NiFpga_Initialize();
	NiFpga_Session hostSession;

	// Open bitfile (Downloads the bitfile to FPGA if it is hasn't been yet)
	status = NiFpga_Open(bitfilePath, NiFpga_HMBFPGA_Signature,
			     "RIO0", NiFpga_OpenAttribute_NoRun,
		             &hostSession);

	if (NiFpga_IsError(status)) {
		printf("Error Opening bitfile %d \n", status);
		return -1;
	}

	// Reset
	status = NiFpga_Reset(hostSession);
	if (NiFpga_IsError(status)) {
		printf("Error reseting %d \n", status);
		return -1;
	}

	// Open host memory buffer
	void* virtualAddress = 0; // The memory address of the HMB on the host side
	size_t size = 0;
	status = NiFpga_OpenHostMemoryBuffer(hostSession,
			                     hostMemoryBufferName,
			                     &virtualAddress,
			                     &size);
	if (NiFpga_IsError(status)) {
		printf("Error opening host memory buffer %d\n", status);
		return -1;
	}

	uint64_t* buffer = (uint64_t *)(virtualAddress);

	// Start the FPGA VI
	status = NiFpga_Run(hostSession, 0);
	if (NiFpga_IsError(status)) {
		printf("Unable to run FPGA VI\n");
		return -1;
	}

	uint64_t value;
	uint32_t address = 1300; // Arbitrary Address

        // Host write to buffer
	buffer[address] = 1001;

	// FPGA read from buffer
	NiFpga_WriteU32(hostSession, NiFpga_HMBFPGA_ControlU32_ReadAddress, address);
	NiFpga_WriteBool(hostSession, NiFpga_HMBFPGA_ControlBool_ReadData, 1);
	NiFpga_ReadU64(hostSession, NiFpga_HMBFPGA_IndicatorU64_DataRead, &value);
	printf("Value read by FPGA is %llu\n", value);

	// FPGA write to buffer
	address = 1301;
	value = 1002;
	NiFpga_WriteU64(hostSession, NiFpga_HMBFPGA_ControlU64_DatatoWrite, value);
	NiFpga_WriteU32(hostSession, NiFpga_HMBFPGA_ControlU32_WriteAddress, address);
	NiFpga_WriteBool(hostSession, NiFpga_HMBFPGA_ControlBool_WriteData, 1);

	// Waiting for fpga to finish writing to the buffer
	sleep(1);

	// Host read from buffer
	value = buffer[address];
	printf("Value read by Host %llu\n", value);

	if (hostSession != 0) {
		NiFpga_Close(hostSession, 0);
	}

	NiFpga_Finalize();
}
