#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>

#include "NiFpga_HMB.h"

// Internal function implemented in NiFpga.c
NiFpga_Status NiFpga_ClientFunctionCall(NiFpga_Session session,
                                        uint32_t group,
                                        uint32_t functionId,
                                        const void* inBuffer,
                                        size_t inBufferSize,
                                        void* outBuffer,
                                        size_t outBufferSize);

static const uint32_t clientFeature_hostMemoryBuffer = 0;
static const uint32_t hostMemoryBufferFunction_open = 2;

// Input arguments for HMB open
struct AtomicHMBOpenInputs
{
   const char* memoryName;
};

// Output arguments for HMB open
struct AtomicHMBOpenOutputs
{
   size_t size;
   void* virtualAddress;
   int32_t errorCode;
};

NiFpga_Status NiFpga_OpenHostMemoryBuffer(NiFpga_Session session,
                                          const char* memoryName,
                                          void** virtualAddress,
                                          size_t* size)
{
   size_t inBufferSize = strlen(memoryName) + 1;
   uint8_t inBuffer[inBufferSize];
   struct AtomicHMBOpenOutputs outputs;

   strcpy((char*)(inBuffer), memoryName);

   NiFpga_Status retval = NiFpga_ClientFunctionCall(session,
                                    clientFeature_hostMemoryBuffer,
                                    hostMemoryBufferFunction_open,
                                    inBuffer,
                                    sizeof(struct AtomicHMBOpenInputs),
                                    (uint8_t*)(&outputs),
                                    sizeof(struct AtomicHMBOpenOutputs));
   if (NiFpga_IsError(retval))
   {
      return retval;
   }
   *virtualAddress = outputs.virtualAddress;
   if (size != NULL)
   {
      *size = outputs.size;
   }
   return outputs.errorCode;
}
